'use strict';

/* --------------------------------------------------------------
 customizer.js 2020-05-12
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

gambio.widgets.module('customizer', [jse.source + '/vendor/jquery-ui-dist/jquery-ui.min.js', gambio.source + '/libs/events'], function (data) {

    'use strict';

    // ########## VARIABLE INITIALIZATION ##########

    var $this = $(this),
        $body = $('body'),
        $window = $(window),
        ajax = null,
        defaults = {
        requestUrl: 'request_port.php?module=GPrint',
        uidSelector: '#gm_gprint_random',
        page: 'product'
    },
        options = $.extend(true, {}, defaults, data),
        module = {};

    /**
     * Add customizer data to cart or wish list.
     *
     * @private
     */
    var _addCustomizerData = function _addCustomizerData(e, d) {

        var formdata = jse.libs.form.getData($this, null, true),
            dataset = $.extend({ 'mode': 'frontend', 'action': e.data.action }, d.dataset, {}, formdata),
            promises = [],
            attribute_id_strings = [],
            add_attribute_string_function = function add_attribute_string_function() {
            var optionId = $(this).attr('name').replace(/(id|modifiers\[attribute\])\[(\d+)\]/, '$2');
            attribute_id_strings.push('{' + optionId + '}' + $(this).val());
        };

        $('.customizer select[name^="id["], .customizer input[name^="id["]:checked').each(add_attribute_string_function);
        $('.customizer select[name^="modifiers[attribute]["], .customizer input[name^="modifiers[attribute]["]:checked').each(add_attribute_string_function);
        $('.customizer input[type=radio][name^="modifiers[attribute]["]:checked').each(add_attribute_string_function);
        $('.customizer input[type=hidden][name^="modifiers[attribute]["]').each(add_attribute_string_function);

        //  removing duplicated ids
        attribute_id_strings = attribute_id_strings.filter(function (value, index, self) {
            return self.indexOf(value) === index;
        });

        var attributeIdsString = attribute_id_strings.join('');

        dataset.products_id = dataset.products_id + attributeIdsString + '{' + e.data.random.match(/\d+/) + '}0';

        $this.find('input[type="file"]').each(function () {
            if ($(this).get(0).files.length > 0) {
                var deferred = $.Deferred();
                promises.push(deferred);

                $(this).hide();
                $(this).parent().append('<img src="gm/images/gprint/upload.gif" width="16" height="11" ' + 'class="gm_gprint_loading" id="loading_' + $(this).attr('id') + '" />');

                _upload($(this), dataset, deferred);
            }
        });

        if (promises.length) {
            $.when.apply(undefined, promises).done(function () {
                _send_customizer_data(e, d, dataset);
            }).always(function () {
                var test = 1;
            });
        } else {
            _send_customizer_data(e, d, dataset);
        }
    };

    /**
     * Upload files from customizer form.
     *
     * @private
     */
    var _upload = function _upload(uploadField, dataset, deferred) {
        var filesList = uploadField.get(0).files,
            url = options.requestUrl + '&action=upload&target=' + dataset.target + '&mode=frontend&upload_field_id=' + uploadField.attr('id') + '&products_id=' + dataset.products_id,
            properties_values_ids = [],
            add_to_properties_array_func = function add_to_properties_array_func() {
            properties_values_ids.push($(this).val());
        };

        $('.customizer select[name^="properties_values_ids["]').each(add_to_properties_array_func);
        $('.customizer select[name^="modifiers[property]["]').each(add_to_properties_array_func);
        $('.customizer input[type=radio][name^="modifiers[property]["]:checked').each(add_to_properties_array_func);
        $('.customizer input[type=hidden][name^="modifiers[property]["]').each(add_to_properties_array_func);

        //  removing duplicated ids
        properties_values_ids = properties_values_ids.filter(function (value, index, self) {
            return self.indexOf(value) === index;
        });

        properties_values_ids.forEach(function (value) {
            url += '&properties_values_ids[]=' + value;
        });

        uploadField.fileupload({
            url: url,
            autoUpload: false,
            dataType: 'json'
        });

        uploadField.fileupload('send', { files: filesList }).done(function (result) {
            var uploadFieldName = uploadField.attr('id'),
                filename = uploadField.val().replace(/C:\\fakepath\\/i, '');

            dataset[uploadFieldName] = filename;
            uploadField.parent().find('img').remove();
            uploadField.show();

            if (result.ERROR) {
                alert(result.ERROR_MESSAGE);
                deferred.reject();
            } else {
                deferred.resolve(result);
            }
        }).fail(function (jqxhr, testStatus, errorThrown) {
            uploadField.parent().find('img').remove();
            uploadField.show();
            deferred.reject();
        });
    };

    /**
     * Send customizer data beloning to a product which is going to be added to the cart.
     *
     * @private
     */
    var _send_customizer_data = function _send_customizer_data(e, d, dataset) {
        ajax = ajax ? ajax.abort() : null;
        ajax = jse.libs.xhr.post({ url: options.requestUrl, data: dataset }, true);

        ajax.done(function () {
            if (d.deferred) {
                d.deferred.resolve(e.data.random);
            }
        }).fail(function () {
            if (d.deferred) {
                d.deferred.reject();
            }
        });
    };

    /**
     * Send customizer data beloning to a wish list product which is going to be added to the cart.
     *
     * @private
     */
    var _wishlist_to_cart = function _wishlist_to_cart(e, d) {
        if (d.dataset.products_id[0].indexOf('}0') === -1) {
            if (d.deferred) {
                d.deferred.resolve();
            }

            return;
        }

        ajax = ajax ? ajax.abort() : null;

        ajax = jse.libs.xhr.post({
            url: options.requestUrl,
            data: {
                action: 'wishlist_to_cart',
                products_id: d.dataset.products_id[0],
                mode: 'frontend'
            }
        }, true);

        ajax.done(function () {
            if (d.deferred) {
                d.deferred.resolve();
            }
        }).fail(function () {
            if (d.deferred) {
                d.deferred.reject();
            }
        });
    };

    /**
     * Delete customizer data belonging to a product which is going to be deleted in cart or wish list.
     *
     * @private
     */
    var _delete = function _delete(e, d) {
        if (d.dataset.products_id[0].indexOf('}0') === -1) {
            if (d.deferred) {
                d.deferred.resolve();
            }

            return;
        }

        var action = 'update_wishlist';
        if (options.page === 'cart') {
            action = 'update_cart';
        }

        ajax = ajax ? ajax.abort() : null;

        ajax = jse.libs.xhr.post({
            url: options.requestUrl,
            data: {
                action: action,
                products_id: d.dataset.products_id[0],
                mode: 'frontend'
            }
        }, true);

        ajax.done(function () {
            if (d.deferred) {
                d.deferred.resolve();
            }
        }).fail(function () {
            if (d.deferred) {
                d.deferred.reject();
            }
        });
    };

    // ########## INITIALIZATION ##########

    /**
     * Init function of the widget
     * @constructor
     */
    module.init = function (done) {
        if (options.page === 'product') {
            var random = $(options.uidSelector).attr('name');
            $body.on(jse.libs.theme.events.ADD_CUSTOMIZER_CART(), { action: 'add_cart', target: 'cart', random: random }, _addCustomizerData);
            $body.on(jse.libs.theme.events.ADD_CUSTOMIZER_WISHLIST(), { action: 'add_wishlist', target: 'wishlist', random: random }, _addCustomizerData);
        }

        $body.on(jse.libs.theme.events.WISHLIST_TO_CART(), _wishlist_to_cart);
        $body.on(jse.libs.theme.events.WISHLIST_CART_DELETE(), _delete);

        $('#gm_gprint_tabs li').on('click', function () {
            $window.trigger(jse.libs.theme.events.STICKYBOX_CONTENT_CHANGE());
        });

        $window.trigger(jse.libs.theme.events.STICKYBOX_CONTENT_CHANGE());

        // jQuery file upload needs to be loaded after jQuery UI. 
        var dependencies = [jse.source + '/vendor/blueimp-file-upload/jquery.fileupload.min.js'];

        window.require(dependencies, done);
    };

    // Return data to widget engine
    return module;
});
//# sourceMappingURL=data:application/json;charset=utf8;base64,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
